<?php

namespace Database\Seeders;

use App\Models\Country;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $countries = $this->getData();
        foreach ($countries as $country) {
            $countryData = Country::where('name', $country["name"])->first();
            if (!$countryData) {
                $countryData = new Country();
                $countryData->sort_name = $country['sortname'];
                $countryData->name = $country['name'];
                $countryData->country_code = $country['phonecode'];
                $countryData->save();
            }
        }
    }

    public function getData()
    {
        $path = storage_path('country/country.json');
        $content = file_get_contents($path);
        return json_decode($content, true);
    }
}
