<?php

use App\Enums\AssociationEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('association_details', function (Blueprint $table) {
            $table->tinyInteger('enable_otp_login')->default(AssociationEnum::NO)->after('mission');
            $table->tinyInteger('otp_via_email')->default(AssociationEnum::NO)->after('enable_otp_login');
            $table->tinyInteger('otp_via_whatsapp')->default(AssociationEnum::NO)->after('otp_via_email');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('association_details', function (Blueprint $table) {
            $table->dropColumn(['enable_otp_login', 'otp_via_email', 'otp_via_whatsapp']);
        });
    }
};
