<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->string('order_id')->nullable()->unique();
            $table->bigInteger('amount')->nullable();
            $table->string('currency')->nullable();
            $table->json('response')->nullable();
            $table->string('status')->default('PENDING');
            $table->string('payment_id')->nullable()->unique();
			$table->string('signature', 560)->nullable()->unique();
            $table->string('referral_code')->nullable();
            $table->string("app_key")->nullable();
            $table->string("payment_mode")->nullable();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_orders');
    }
};
