<?php

use App\Enums\PollOptionAnswerTypeEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('poll_options', function (Blueprint $table) {
            $table->tinyInteger('answer_type')->default(PollOptionAnswerTypeEnum::WRONG)->comment('1 => Right, 0 => Wrong')->after('type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('poll_options', function (Blueprint $table) {
            $table->dropColumn('answer_type');
        });
    }
};
