<?php

use App\Enums\EventFormFieldTypeEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('event_form_input_fields', function (Blueprint $table) {
            $table->id();
            $table->foreignId('event_id')->nullable()->constrained()->cascadeOnDelete();
            $table->string('label')->nullable();
            $table->string('name')->nullable();
            $table->string('default_value')->nullable();
            $table->tinyInteger('field_accept_value')->nullable()->comment("1=> alpha numeric, 2=> Only Alphabets 3=> Only Numeric");
            $table->text('helper_text')->nullable();
            $table->integer('index')->default(1);
            $table->string('type')->nullable();
            $table->tinyInteger('required')->default(0);
            $table->json('options')->nullable();
            $table->tinyInteger('visible')->default(0);
            $table->tinyInteger('field_type')->default(EventFormFieldTypeEnum::DYNAMIC)->comment('1 => Static, 2 => Dynamic');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('event_form_input_fields');
    }
};
