<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_exhibitors', function (Blueprint $table) {
            $table->dropColumn('category');
            $table->foreignId('event_exhibitor_category_id')->after('sponsor_type')->nullable()->constrained()->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_exhibitors', function (Blueprint $table) {
            $table->dropForeign(['event_exhibitor_category_id']);
            $table->dropColumn('event_exhibitor_category_id');
            $table->string('category')->nullable()->after('sponsor_type');
        });
    }
};
