<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_exhibitors', function (Blueprint $table) {
            $table->string('company_name')->nullable()->after('name');
            $table->string('sponsor_type')->nullable()->after('company_name');
            $table->string('category')->nullable()->after('sponsor_type');
            $table->longText('address')->nullable()->after('connect');
            $table->foreignId('media_id')->nullable()->constrained()->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_exhibitors', function (Blueprint $table) {
            $table->dropForeign(['media_id']);
            $table->dropColumn('media_id');
            $table->dropColumn('category');
            $table->dropColumn('company_name');
            $table->dropColumn('sponsor_type');
            $table->dropColumn('address');
        });
    }
};
