<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_days', function (Blueprint $table) {
            $table->string('text_color', 7)->nullable()->comment('Hex value for text color (e.g., #FFFFFF)')->after('date');
            $table->string('bg_color', 7)->nullable()->comment('Hex value for background color (e.g., #FF5733)')->after('text_color');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_days', function (Blueprint $table) {
            $table->dropColumn('text_color');
            $table->dropColumn('bg_color');
        });
    }
};
