<?php

use App\Enums\EventSessionEnum;
use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_sessions', function (Blueprint $table) {
            $table->tinyInteger('status')->nullable()->after('parent_id')->default(EventSessionEnum::UPCOMING_STATUS)->comment("1 : Upcoming, 2: Ongoing, 3: Completed");
            $table->renameColumn('extra', 'notes');
            $table->tinyInteger('ask_questions')->nullable()->after('parent_id')->default(StatusEnum::DEACTIVE)->comment("1 : Yes, -1: No");
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_sessions', function (Blueprint $table) {
            $table->dropColumn('status');
            $table->dropColumn('ask_questions');
            $table->renameColumn('notes', 'extra');
        });
    }
};
