<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scroller_images', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->text('description')->nullable();
            $table->integer('index')->nullable();
            $table->tinyInteger('status')->default(StatusEnum::ACTIVE)->comment('1 => Active, 0 => Deactive');
            $table->unsignedBigInteger("media_id")->nullable();
            $table->foreign("media_id")->on("media")->references("id")->cascadeOnDelete();
            $table->morphs('imageable');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scroller_images');
    }
};
