<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('member_details', function (Blueprint $table) {
            $table->dropForeign(['member_id']);
            $table->dropForeign(['association_id']);
            $table->dropForeign(['role_id']);
            $table->dropForeign(['media_id']);
            $table->foreign("member_id")->references("id")->on("users")->cascadeOnDelete();
            $table->foreign("association_id")->references("id")->on("users")->cascadeOnDelete();
            $table->foreign("role_id")->on("member_roles")->references("id")->cascadeOnDelete();
            $table->foreign("media_id")->on("media")->references("id")->cascadeOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('member_details', function (Blueprint $table) {
            $table->dropForeign(['member_id']);
            $table->dropForeign(['association_id']);
            $table->dropForeign(['role_id']);
            $table->dropForeign(['media_id']);
            $table->foreign("member_id")->references("id")->on("users");
            $table->foreign("association_id")->references("id")->on("users");
            $table->foreign("role_id")->on("member_roles")->references("id");
            $table->foreign("media_id")->on("media")->references("id");
        });
    }
};
