<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('past_office_bearers', function (Blueprint $table) {
            $table->id();
            $table->year('year');
            $table->unsignedBigInteger("association_id")->nullable();
            $table->foreign("association_id")->references("id")->on("users");
            $table->unsignedBigInteger('president_id')->nullable();
            $table->foreign('president_id')->references('id')->on('users')->onDelete('cascade');
            $table->unsignedBigInteger('vice_president_id')->nullable();
            $table->foreign('vice_president_id')->references('id')->on('users')->onDelete('cascade');
            $table->unsignedBigInteger('secretary_id')->nullable();
            $table->foreign('secretary_id')->references('id')->on('users')->onDelete('cascade');
            $table->unsignedBigInteger('treasurer_id')->nullable();
            $table->foreign('treasurer_id')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('past_office_bearers');
    }
};
