<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_registrations', function (Blueprint $table) {
            $table->unsignedBigInteger('user_id')->after('event_id')->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->unsignedBigInteger("association_id")->nullable()->after('user_id');
            $table->foreign("association_id")->references("id")->on("users");
            $table->dropColumn(['name', 'email', 'contact']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_registrations', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['association_id']);
            $table->dropColumn(['user_id', 'association_id']);
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('contact')->nullable();
        });
    }
};
