<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('calendars', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("association_id")->nullable();
            $table->foreign("association_id")->references("id")->on("users");
            $table->string('title');
            $table->text('description')->nullable();
            $table->timestamp('date');
            $table->string('link', 200)->nullable();
            $table->unsignedBigInteger("media_id")->nullable();
            $table->foreign("media_id")->on("media")->references("id");
            $table->tinyInteger('status')->default(StatusEnum::INACTIVE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('calendars');
    }
};
