<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //relationship drop
        Schema::table('committee_members', function (Blueprint $table) {
            $foreignKeys = Schema::getConnection()->getSchemaBuilder()->getForeignKeys('committee_members');
            foreach ($foreignKeys as $foreignKey) {
                if (isset($foreignKey['columns'][0])) {
                    if ($foreignKey['columns'][0] == 'member_id') {
                        $table->dropForeign(['member_id']);
                    }
                }
            }
        });

        Schema::table('message_campaign_users', function (Blueprint $table) {
            $foreignKeys = Schema::getConnection()->getSchemaBuilder()->getForeignKeys('message_campaign_users');
            foreach ($foreignKeys as $foreignKey) {
                if (isset($foreignKey['columns'][0])) {
                    if ($foreignKey['columns'][0] == 'user_id') {
                        $table->dropForeign(['user_id']);
                    }
                }
            }
        });

        Schema::dropIfExists('members');
    }

    /**
     * Reverse the migrations.
     */

    public function down(): void
    {
        return;
    }
};
