<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mail_template_campaigns', function (Blueprint $table) {
            $table->id();
            $table->string('template_name')->nullable();
            $table->date('scheduled_date')->nullable();
            $table->time('scheduled_time')->nullable();
            $table->dateTime('scheduled_at')->nullable();
            $table->bigInteger('total_users')->nullable();
            $table->longText('users')->nullable();
            $table->longText('success_users')->nullable();
            $table->longText('fail_users')->nullable();
            $table->tinyInteger('status')->default(0)->comment('0 => pending, 1=>in-progress 2=>success')->nullable();
            $table->string('schedule_type')->default('send_now')->comment('send_now & send_later');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mail_template_campaigns');
    }
};
