<?php

use App\Enums\MetaFileExtensionEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('messages', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sender_id')->nullable()->comment('null => admin');
            $table->unsignedBigInteger('receiver_id')->nullable()->comment('null => admin');
            $table->unsignedBigInteger('message_template_id')->nullable();
            $table->foreign('message_template_id')->references('id')->on('message_templates')->onDelete('cascade');
            $table->text('message')->nullable();
            $table->string('message_id')->nullable();
            $table->bigInteger('replied_message_id')->nullable()->comment('replied on some particular message');
            $table->timestamp("sent_at")->nullable();
            $table->timestamp("delivered_at")->nullable();
            $table->timestamp("read_at")->nullable();
            $table->string("status", 10)->default("PENDING");
            $table->unsignedBigInteger('meta_chat_room_id')->nullable();
            $table->foreign('meta_chat_room_id')->on('meta_chat_rooms')->references('id')->onDelete('cascade');
            $table->unsignedBigInteger('message_campaign_id')->nullable();
            $table->foreign('message_campaign_id')->on('message_campaigns')->references('id')->onDelete('cascade');
            $table->integer('type')->default(MetaFileExtensionEnum::TYPE['text'])->comment("text = 1, image = 2, video = 3, document = 4, sticker = 5");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('messages');
    }
};
