<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('committee_members', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("association_id")->nullable();
            $table->foreign("association_id")->references("id")->on("users");
            $table->unsignedBigInteger("commity_id")->nullable();
            $table->foreign("commity_id")->on("committees")->references("id")->onDelete('cascade');
            $table->unsignedBigInteger("member_id")->nullable();
            $table->foreign("member_id")->on("members")->references("id")->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('committee_members');
    }
};
