<?php

use App\Http\Middleware\UserRoleIsValid;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        api: __DIR__ . '/../routes/api.php',
        apiPrefix: 'api/',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'isValidRole' => App\Http\Middleware\UserRoleIsValid::class,
            'checkAuthCode' => App\Http\Middleware\CheckAuthCode::class,
            'checkEvent' => App\Http\Middleware\CheckEvent::class,
        ]);
    })
    ->withCommands([
        __DIR__.'/../app/Domain/Orders/Commands',
    ])
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
