<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class DisposableEmailRule implements ValidationRule
{
    protected array $disposableDomains = [
        'mailinator.com',
        'yopmail.com',
        // Add more domains as needed
    ];

    /**
     * Run the validation rule.
     *
     * @param  \Closure(string, ?string = null): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $domain = substr(strrchr($value, '@'), 1);

        if (in_array($domain, $this->disposableDomains)) {
            $fail('The ' . $attribute . ' cannot be a disposable email address.');
        }
    }

    /**
     * Check if the given email address is disposable.
     *
     * @param string $email
     * @return bool
     */
    public function isDisposable(string $email): bool
    {
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            return false;
        }

        $domain = substr(strrchr($email, '@'), 1);
        return in_array($domain, $this->disposableDomains);
    }
}
