<?php

namespace App\Providers;

use App\Models\MailTemplateCampaign;
use App\Models\MessageCampaign;
use App\Models\PostComment;
use App\Models\PostLike;
use App\Observers\MailTemplateCampaignObserver;
use App\Observers\MessageCampaignObserver;
use App\Observers\PostCommentObserver;
use App\Observers\PostLikeObserver;
use Illuminate\Auth\Events\Registered;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        Registered::class => [
            // SendEmailVerificationNotification::class,
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        MessageCampaign::observe(MessageCampaignObserver::class);
        MailTemplateCampaign::observe((MailTemplateCampaignObserver::class));
        PostLike::observe(PostLikeObserver::class);
        PostComment::observe(PostCommentObserver::class);
    }
}
