<?php

namespace App\Observers;

use App\Enums\MessageCampaignEnum;
use App\Models\MessageCampaign;

class MessageCampaignObserver
{
        /**
     * Handle the MessageTemplateCompaign "saved" event.
     *
     * @param  \App\Models\MessageCampaign  $messageTemplateCompaign
     * @return void
     */
    public function creating(MessageCampaign $messageCampaign)
    {
        $messageCampaign->success_users = [];
        $messageCampaign->fail_users = [];
        $messageCampaign->sent_users = [];
        $messageCampaign->delivered_users = [];
        $messageCampaign->read_users = [];
        $messageCampaign->scheduled_at = date(
            'Y-m-d H:i',
            strtotime($messageCampaign->scheduled_date . ' ' . $messageCampaign->scheduled_time)
        );
    }

    /**
     * Handle the MessageTemplateCompaign "created" event.
     *
     * @param  \App\Models\MessageCampaign  $messageTemplateCompaign
     * @return void
     */
    public function created(MessageCampaign $messageCampaign)
    {
        $messageCampaign->campaign_unique_id = strtotime(date('Y-m-d H:i:s', strtotime($messageCampaign->created_at))) . $messageCampaign->id;
        $messageCampaign->save();
    }

    public function updated(MessageCampaign $messageCampaign)
    {
        if ($messageCampaign->status == MessageCampaignEnum::SUCCESS) {
            if (!empty($messageCampaign->success_users)) {
                $successUsers = $messageCampaign->success_users;
                if (count($successUsers) > 0) {
                    // if (!WalletTransaction::ofTransactionable($messageCampaign)->exists()) {
                    //     WalletTransaction::create([
                    //         'transactionable_id' => $messageCampaign->id,
                    //         'transactionable_type' => MessageCampaign::class,
                    //         'messages' => count($successUsers) * -1,
                    //     ]);
                    // }
                }
            }
        }
    }
}
