<?php

namespace App\Models;

use App\Enums\PollOptionTypeEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class PollOption extends Model
{
    use HasFactory;

    protected $fillable = [
        'association_id',
        'poll_id',
        'option',
        'answer_type',
        'type',
        'vote_count'
    ];

    public function poll()
    {
        return $this->belongsTo(Poll::class);
    }

    public function image(): BelongsTo
    {
        return $this->belongsTo(Media::class, 'option');
    }


    public function votedByUsers(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'poll_votes', 'poll_option_id', 'user_id')
            ->withTimestamps()
            ->withPivot('poll_id');
    }

    public function isVotedByUser(User $user)
    {
        return $this->votedByUsers()->where('user_id', $user->id)->exists() ? 1 : 0;
    }

    // vote poll
    public function VotePoll(User $user)
    {
        if (!$this->isVoted($user)) {
            $this->votedByUsers()->attach($user->id, [
                'poll_id' => $this->poll_id,
            ]);
        }
    }

    public function updateVoteCount()
    {
        $this->update([
            'vote_count' => $this->votedByUsers()->count()
        ]);
    }

    public function removeVote(User $user)
    {
        $this->votedByUsers()->detach($user);
    }

    public function isVoted(User $user): bool
    {
        return $this->votedByUsers()->where('user_id', $user->id)->exists();
    }
}
