<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Poll extends Model
{
    use HasFactory;

    protected $fillable = [
        'association_id',
        'question',
        'start_time',
        'start_date',
        'expire_date',
        'expire_time',
        'status',
        'index',
        'declare'
    ];

    protected static function booted()
    {
        static::addGlobalScope('orderById', function (Builder $builder) {
            $builder->orderByDesc('id');
        });
    }

    public function pollOptions()
    {
        return $this->hasMany(PollOption::class);
    }
}
