<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PaymentOrder extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $fillable = [
        'event_id',
        'user_id',
        'order_id',
        'amount',
        'currency',
        'response',
        'status',
        'payment_id',
        'signature',
        'referral_code',
        'app_key',
        'payment_mode',
        'member_data'
    ];

    protected $casts = [
        'member_data' => 'array',
        'response' => 'array'
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function event()
    {
        return $this->belongsTo(Event::class, "event_id");
    }

    public static function getForReferralCode($referralCode)
    {
        return PaymentOrder::where("referral_code", $referralCode)->first();
    }

    public static function getPaymentReceipt($id)
    {
        $receipt = Media::find($id);
        if($receipt && $receipt->path){
            return $receipt->path;
        }
        return null;
    }
}
