<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PastOfficeBearer extends Model
{
    use HasFactory;

    protected $fillable = [
        'association_id',
        'year',
        'president_id',
        'vice_president_id',
        'secretary_id',
        'treasurer_id',
    ];

    protected $casts = [
        // 'year' => 'date:Y',
    ];

    public function president()
    {
        return $this->belongsTo(User::class, 'president_id');
    }

    public function vicePresident()
    {
        return $this->belongsTo(User::class, 'vice_president_id');
    }

    public function secretary()
    {
        return $this->belongsTo(User::class, 'secretary_id');
    }

    public function treasurer()
    {
        return $this->belongsTo(User::class, 'treasurer_id');
    }

    public function association()
    {
        return $this->belongsTo(User::class, 'association_id');
    }


    public function scopeSearchByName($query, $request)
    {

        $query->where(function ($subQuery) use ($request) {
            $subQuery->whereHas('president', function ($q) use ($request) {
                $q->where("name", 'like', '%' . $request->name . '%');
            })
                ->orWhereHas('vicePresident', function ($q) use ($request) {
                    $q->where("name", 'like', '%' . $request->name . '%');
                })
                ->orWhereHas('secretary', function ($q) use ($request) {
                    $q->where("name", 'like', '%' . $request->name . '%');
                })
                ->orWhereHas('treasurer', function ($q) use ($request) {
                    $q->where("name", 'like', '%' . $request->name . '%');
                })
                ->orWhereHas('association', function ($q) use ($request) {
                    $q->where("name", 'like', '%' . $request->name . '%');
                });
        });

        return $query;
    }
}
