<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OtpRequest extends Model
{
    use HasFactory;

    public const STATUS_PENDING = 0;
    public const STATUS_VERIFIED = 1;
    public const STATUS_EXPIRED = 2;


    protected $fillable = [
        'country_code',
        'contact',
        'otp',
        'status',
        'verified_at',
    ];

    protected $casts = [
        'verified_at' => 'datetime',
    ];

    /**
     * @return string
     */
    public function getWatiContactAttribute()
    {
        $countryCode = str_replace("+", "", $this->country_code);
        return "$countryCode $this->contact";
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
