<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Notice extends Model
{
    use HasFactory;

    protected $fillable = [
        'association_id',
        'media_id',
        'title',
        'link',
        'index',
        'status',
    ];

    protected $casts = [
        'index' => 'integer'
    ];

    /**
     * @return BelongsTo
     */

    public function image(): BelongsTo
    {
        return $this->belongsTo(Media::class, 'media_id');
    }
}
