<?php

namespace App\Models;

use DateTime;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MetaChatRoom extends Model
{
    use HasFactory;

    protected $table = "meta_chat_rooms";

    protected $fillable = [
        "user_id",
        "last_updated_at",
        "unread_count",
        "last_message_id",
    ];

    public function latestChat($userId)
    {
        $message = Message::where('receiver_id', $userId)->orWhere('sender_id', $userId)->latest()->first();
        return $message;
    }

    public function getRemainingExpireTimeAttribute()
    {
        $expireDateTime = new DateTime($this->expire_at);
        $currentDateTime = new DateTime(date('Y-m-d H:i:s'));
        $diff = $currentDateTime->diff($expireDateTime);
        $result = $diff->format('%h.%i Hr');
        return $result;
    }

    public function getIsExpiredAttribute()
    {
        $isExpired = false;
        if ($this->expire_at < date('Y-m-d H:i:s')) {
            $isExpired = true;
        }
        return $isExpired;
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
