<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MessageCampaignUser extends Model
{
    use HasFactory;

    const STATUS_PENDING = "PENDING";
    const STATUS_SENT = "SENT";
    const STATUS_FAILED = "FAILED";

    protected $fillable = [
        "message_campaign_id",
        "user_id",
        "message_id",
        "contact",
        "status",
        "sent_at",
        "delivered_at",
        "replied_at"
    ];

    public function user()
    {
        return $this->belongsTo(User::class, "user_id");
    }

    public function campaign()
    {
        return $this->belongsTo(MessageCampaign::class, "message_campaign_id");
    }

    public function sent()
    {
        $this->status = "sent";
        $this->sent_at = Carbon::now()->toDateTimeString();
        $this->save();
    }

    public function delivered()
    {
        $this->status = "delivered";
        $this->delivered_at = Carbon::now()->toDateTimeString();
        $this->save();
    }

    public function read()
    {
        $this->status = "read";
        $this->read_at = Carbon::now()->toDateTimeString();
        $this->save();
    }
}
