<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Message extends Model
{
    use HasFactory;

    protected $fillable = [
        "sender_id",
        "receiver_id",
        "message_template_id",
        "message",
        "message_id",
        "replied_message_id",
        "expire_at",
        "meta_chat_room_id",
        "message_campaign_id",
        "type",
    ];

    public function receiverUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'receiver_id');
    }

    public function senderUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'sender_id');
    }

    public function messageTemplate(): BelongsTo
    {
        return $this->belongsTo(MessageTemplate::class, 'message_template_id');
    }

    public function getRepliedMessageTextAttribute()
    {
        $message = Message::where('id', $this->replied_message_id)->first();
        if (isset($message)) {
            return $message->message;
        }
        return '';
    }

    public function sent()
    {
        $this->sent_at = Carbon::now()->toDateTimeString();
        $this->status = "sent";
        $this->save();
    }

    public function delivered()
    {
        $this->delivered_at = Carbon::now()->toDateTimeString();
        $this->status = "delivered";
        $this->save();
    }

    public function read()
    {
        $this->read_at = Carbon::now()->toDateTimeString();
        $this->status = "read";
        $this->save();
    }
}
