<?php

namespace App\Models;

use App\Enums\MembershipFormFieldEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MembershipFormField extends Model
{
    use HasFactory;

    protected $fillable = [
        "label",
        "name",
        "default_value",
        "helper_text",
        "index",
        "type",
        "required",
        "options",
        "visible",
        "field_accept_value",
        "association_id",
    ];

    protected $casts = [
        'options' => 'array',
    ];

    protected $hidden = [
        'id',
        'field_accept_value',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected $appends = [
        'accepted_value'
    ];

    public function getAcceptedValueAttribute()
    {
        return match ($this->field_accept_value) {
            MembershipFormFieldEnum::FIELD_ACCEPT_ALPHA_NUMBERIC => "Alpha Numeric",
            MembershipFormFieldEnum::FIELD_ACCEPT_ALPHABETS => "Alphabets",
            MembershipFormFieldEnum::FIELD_ACCEPT_NUMBERIC => "Numeric",
            MembershipFormFieldEnum::FIELD_ACCEPT_IMAGE => "image/*",
            default => "",
        };
    }
}
