<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MailTemplate extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'template_id',
        'name',
        'from',
        'subject',
        'dynamic_variables',
        'attachment',
        'status',
    ];

    protected $casts = [
        'dynamic_variables' => 'array',
        'attachment' => 'array',
    ];

    public function getAttachments()
    {
        return Media::find($this->attachment);
    }

    public function getAttachment($id)
    {
        return Media::find($id);
    }
}
