<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class InternationalAffiliation extends Model
{
    use HasFactory;

    protected $fillable = [
        'association_id',
        'name',
        'link',
        'media_id',
        'index',
        'status'
    ];

    public function association(): BelongsTo
    {
        return $this->belongsTo(User::class, 'association_id');
    }

    public function image(): BelongsTo
    {
        return $this->belongsTo(Media::class, 'media_id');
    }
}
