<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EventSessionUser extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_session_id',
        'event_faculty_id',
        'event_speaker_id',
        'user_id',
        'title',
        'event_designation_id',
    ];

    /**
     * @return BelongsTo
     */
    public function user(): BelongsTo
    {
        return $this->BelongsTo(User::class, 'user_id');
    }

    public function eventSessions()
    {
        return $this->belongsTo(EventSession::class, 'event_session_id');
    }

}
