<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventSessionQuestion extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_session_id',
        'question',
        'from',
        'to',
    ];


    public function eventSession()
    {
        return $this->belongsTo(EventSession::class, 'event_session_id');
    }

    public function fromUser()
    {
        return $this->belongsTo(User::class, 'from');
    }

    public function toUser()
    {
        return $this->belongsTo(User::class, 'to');
    }
}
