<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventMailTemplate extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'template_id',
        'name',
        'from',
        'subject',
        'dynamic_variables',
        'attachment',
        'cc',
        'bcc',
        'status',
    ];

    protected $casts = [
        'dynamic_variables' => 'array',
        'attachment' => 'array',
        'cc' => 'array',
        'bcc' => 'array',
    ];

    public function getAttachments()
    {
        return Media::find($this->attachment);
    }

    public function getAttachment($id)
    {
        return Media::find($id);
    }
}
