<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class EventLocation extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'name',
        'description',
        'media_ids',
        'index',
        'extra',
    ];

    protected $casts = [
        'extra' => 'array'
    ];

    protected static function booted()
    {
        static::addGlobalScope('orderByIndex', function (Builder $builder) {
            $builder->orderBy('index');
        });
    }

    public function getMedia()
    {
        $mediaIds = explode(',', $this->media_ids);

        $mediaCollection = Media::whereIn('id', $mediaIds)->get();

        return $mediaCollection->map(function ($media) {
            return [
                'id' => $media->id,
                'name' => $media->name,
                'path' => getFilePath($media->path),
            ];
        });
    }
}
