<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventImportantDate extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'date',
        'description',
        'status',
    ];

    protected $casts = [
        'date' => 'date',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected static function booted()
    {
        static::addGlobalScope('orderByDate', function (Builder $builder) {
            $builder->orderBy('date');
        });
    }
}
