<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class EventHall extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'name',
        'text_color',
        'bg_color',
        'status',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * @return BelongsTo
     */
    public function event(): BelongsTo
    {
        return $this->BelongsTo(Event::class, 'event_id');
    }

    public function eventSessions(): HasMany
    {
        return $this->hasMany(EventSession::class, 'event_hall_id');
    }

    public function eventParentSessions()
    {
        return $this->hasMany(EventSession::class, 'event_hall_id')
            ->whereNull('parent_id');
    }
}
