<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EventFormSlabCategory extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'event_form_slab_id',
        'event_form_category_id',
        'amount',
    ];

    public function eventFormCategory(): BelongsTo
    {
        return $this->BelongsTo(EventFormCategory::class, 'event_form_category_id');
    }
}
