<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventEPoster extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'title',
        'presenter_id',
        'abstract_id',
        'co_author',
        'institute',
        'event_e_poster_category_id',
        'poster_id',
        'index',
        'status',
    ];

    protected $casts = [
        'co_author' => 'array',
    ];

    protected static function booted()
    {
        static::addGlobalScope('orderByIndex', function (Builder $builder) {
            $builder->orderBy('index');
        });
    }

    public function event()
    {
        return $this->belongsTo(Event::class, 'event_id');
    }

    public function media()
    {
        return $this->belongsTo(Media::class, 'poster_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'presenter_id');
    }

    public function EPosterCategory()
    {
        return $this->belongsTo(EventEPosterCategory::class, 'event_e_poster_category_id');
    }
}
