<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class EventDesignation extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'designation',
    ];

    /**
     * @return BelongsTo
     */
    public function event(): BelongsTo
    {
        return $this->belongsTo(Event::class, 'event_id');
    }

    /**
     * @return HasMany
     */
    public function eventSessionUsers(): HasMany
    {
        return $this->hasMany(EventSessionUser::class, 'event_designation_id');
    }
}
