<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class EventContactUsType extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'name',
        'index',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected static function booted()
    {
        static::addGlobalScope('orderByIndex', function (Builder $builder) {
            $builder->orderBy('index');
        });
    }

    public function eventContactUs(): HasMany
    {
        return $this->hasMany(EventContactUs::class, 'event_contact_us_type_id');
    }
}
