<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EventContactUs extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'event_contact_us_type_id',
        'name',
        'email',
        'country_code',
        'contact',
        'designation',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function type(): BelongsTo
    {
        return $this->BelongsTo(EventContactUsType::class, 'event_contact_us_type_id');
    }
}
