<?php

namespace App\Models;

use App\Enums\StatusEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventConfig extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'online_mail_template',
        'offline_mail_template',
        'online_wati_template',
        'offline_wati_template',
        'offline_mail_template_before_confirmation',
        'offline_wati_template_before_confirmation',
    ];

    public function onlineMailTemplate()
    {
        return $this->belongsTo(EventMailTemplate::class, 'online_mail_template');
    }

    public function onlineMailTemplateActive()
    {
        return $this->belongsTo(EventMailTemplate::class, 'online_mail_template')
            ->where('status', StatusEnum::ACTIVE);
    }

    public function offlineMailTemplate()
    {
        return $this->belongsTo(EventMailTemplate::class, 'offline_mail_template');
    }

    public function offlineMailTemplateActive()
    {
        return $this->belongsTo(EventMailTemplate::class, 'offline_mail_template')
            ->where('status', StatusEnum::ACTIVE);
    }

    public function offlineMailTemplateBeforeConfirmationActive()
    {
        return $this->belongsTo(EventMailTemplate::class, 'offline_mail_template_before_confirmation')
            ->where('status', StatusEnum::ACTIVE);
    }
}
