<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class EventCommitteeMember extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'committee_id',
        'member_id',
        'role_id',
        'index'
    ];

    protected static function booted()
    {
        static::addGlobalScope('orderByIndex', function (Builder $builder) {
            $builder->orderBy('index');
        });
    }

    public function member()
    {
        return $this->belongsTo(User::class, 'member_id');
    }

    public function committee()
    {
        return $this->belongsTo(EventCommittee::class, 'committee_id');
    }

    public function role()
    {
        return $this->belongsTo(EventMemberRole::class, 'role_id');
    }
}
