<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class EventButton extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'name',
        'link',
        'index'
    ];

    // Global scope to order by index ascending
    protected static function booted()
    {
        static::addGlobalScope('orderByIndex', function (Builder $builder) {
            $builder->orderBy('index');
        });
    }

    public function getMedia()
    {
        $mediaIds = explode(',', $this->media_ids);

        $mediaCollection = Media::whereIn('id', $mediaIds)->get();

        return $mediaCollection->map(function ($media) {
            return [
                'id' => $media->id,
                'name' => $media->name,
                'path' => getFilePath($media->path),
            ];
        });
    }
}
