<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class EventAppHomeButton extends Model
{
    use HasFactory;

    protected $fillable = [
        'event_id',
        'name',
        'key',
        'link',
        'text_color',
        'bg_color',
        'media_id',
        'status',
        'index',
        'type'
    ];

    public function getFormattedNameAttribute()
    {
        return ucwords(str_replace('_', ' ', $this->attributes['name']));
    }

    protected static function booted()
    {
        static::addGlobalScope('orderByIndex', function (Builder $builder) {
            $builder->orderBy('index');
        });
    }

    public function image()
    {
        return $this->belongsTo(Media::class, 'media_id');
    }
}
