<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

class Committee extends Model
{
    use HasFactory;


    protected $fillable = [
        'name',
        'status',
        'association_id',
        'index',
    ];

    // Global scope to order by index ascending
    protected static function booted()
    {
        static::addGlobalScope('orderByIndex', function (Builder $builder) {
            $builder->orderBy('index');
        });
    }
}
